package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.Comment;
import gov.va.vinci.dart.biz.NestableComment;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.json.CommentListView;
import gov.va.vinci.dart.rule.TestAbstractDocumentRuleEvaluator;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;

import java.util.ArrayList;
import java.util.List;

import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestCommentListViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");

		try {
			DartObjectFactory.getInstance().getUserManager().login(token);
			SecurityContextHolder.getContext().setAuthentication(token);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Test
	public void testOne() throws Exception {
		CommentListViewBuilder builder = new CommentListViewBuilder();
		
		CommentListView clv = builder.build(null);
		Assert.assertNotNull(clv);
		Assert.assertNotNull(clv.getComments());
		Assert.assertEquals(clv.getComments().size(), 0);
		
		List<NestableComment> ncList = new ArrayList<NestableComment>();
		
		clv = builder.build(ncList);
		Assert.assertNotNull(clv);
		Assert.assertNotNull(clv.getComments());
		Assert.assertEquals(clv.getComments().size(), 0);

		// create a request and add some comments
		Request request = TestAbstractDocumentRuleEvaluator.createARequest();
		Comment comment = Comment.create("test description", request, "DNS", "test comment text");
		Comment c2 = Comment.create("test two", request, "DNS", "test comment text two");
		c2.setPreviousComment(comment);
		Comment c3 = Comment.create("test three", request, "DNS", "test comment text three");
		c3.setPreviousComment(comment);
		
		Assert.assertNotNull(request);
		
		ncList = DartObjectFactory.getInstance().getCommentDAO().listByRequestId(request.getId());
		Assert.assertNotNull(ncList);
		Assert.assertTrue(ncList.size() > 0);
		
		NestableComment nc = ncList.get(0);
		Assert.assertNotNull(nc);
		
		Assert.assertEquals(nc.getText(), "test comment text");
	}
	
}
